------------------------------------------------------------------------------
-- Tool Color Changer
--
-- $Revision$
--
-- Uses the IUP color wheel to change the colors of tools within Fusion....!
--
-- written by : Sean Konrad (sean@eyeonline.com)
--              February 15th, 2005
------------------------------------------------------------------------------

-----------------------------------------------------------------------------
-- INITIAL NOTES
--
-- IUP's color scheme stuff uses color values of 1-256.  Or maybe 0-255.  Either way, I'm therefore
-- dividing all RGB values returned by the IUP color wheel by 256 in order to make them standard 0-1
-- color ranges that are used by the RGB values in the tool.TileColor and tool.TextColor property fields.
-- Note that there's no lexical turn for these hidden properties.  They differ from inputs/outputs (or properties)
-- because they're no actually input or output objects, and they're not attributes as they are not part of the
-- attributes table.  As such I've taken to calling them anonymous object properties, but this will likely change.
-- The initial tests for this script involved an iup timer that would update the tool colors only occasionally
-- so as not to flood eyeonscript - much to my delight, I've found that the anonymous properties have
-- responded nicely to IUP callbacks, as such color changes appear in real time in the interface.  As such
-- the iup timer is not needed.
-- The interface is ugly / non standard Fusion, but such is life.
-----------------------------------------------------------------------------



-- Define a function that will be used to update what tools are being manipulated in the Fusion interface.
function refreshSelectedTools(allBol)
	
	-- Get all selected tools...
	toollist = comp:GetToolList(allBol, "GroupOperator")

	-- iterate!!!!
	for i, tool in pairs(toollist) do
		
		-- set the colors to nil to avoid some, indefinitive weirdness.
		tool.FillColor = nil
		bgColor = nil
	end
end

-- call that function to create the environment..
refreshSelectedTools(true)

-- button for refreshing the interface..  FLAT = "YES" doesn't seem to be doing much, though it might be a win2k thing.
btn_refresh = iup.button{ title = "Reset Selected Tools", size="130x20", FLAT="YES"}
-- copying color settings from SELECTED tool
btn_copy = iup.button{ title = "Copy Color", size="130x20", FLAT="YES"}
btn_paste = iup.button{ title = "Paste Color", size="130x20", FLAT="YES"}
-- resetting the color settings of all tools.
btn_globalReset = iup.button{ title = "Reset All Tools", size="130x20", FLAT="YES"}

-- The function that does the actual color manipulation.
function shiftColors()
	
	-- iterate through the toollist, change the colors as appropriate.
	for i, tool in pairs(toollist) do
		tool.FillColor = bgColor
		
	end
	
	-- return to its default state.
	return iup.DEFAULT
end


-- define the color wheels.  Fusion's color wheel is not available.
cb = iup.colorbrowser{{title = "test", BGCOLOR = "50 50 50"}}

-- functions to update the variables used to shift the colors..
function update(r, g, b)
	bgColor = {R = r/256, G = g /256, B = b/256}
end


-- actions that are performed when the color controls are manipulated.
function cb:drag_cb(r, g ,b)
  update(r,g,b)
  shiftColors()
end

function cb:change_cb(r, g ,b)
  update(r,g,b)
  shiftColors()
end


-- refresh button action.
function btn_refresh:action()
	refreshSelectedTools(true)
end

-- copy button action.
function btn_copy:action()
	if comp.ActiveTool then
		copyBufferBG = {}
		copyBufferBG = comp.ActiveTool.FillColor
	end
end

-- paste button action.
function btn_paste:action()
	if copyBufferBG or copyBufferText then
		refreshSelectedTools(true)
		
		if copyBufferBG then update(copyBufferBG.R*256,copyBufferBG.G*256,copyBufferBG.B*256) end
		shiftColors()
	end
end

function btn_globalReset:action()
    refreshSelectedTools(false)
end

-- People were getting confused by the operation of the script, so I wrote a little something so that they could make sense of it from within the interface.
instructions = "Drag select the tools you wish to\nchange in the flow, activate them \nby hitting 'reset', deselect them\nin the flow and watch their color\nupdate in real time while you \nmanipulate the colorwheels\n\n" 

-- show the dialog.
dlg = iup.dialog{iup.hbox { 
					iup.vbox{
						iup.label{title = instructions},btn_refresh, btn_copy, btn_paste, btn_globalReset
					}, 
					iup.vbox{iup.label{title = "Background Color\n"}, cb}},
					title = "Change Tool Colors", 
					MARGIN= "20x20", TOPMOST = "YES",  BGCOLOR="60 60 60", FGCOLOR = "200 200 200", RESIZE = "NO"}


dlg:showxy(iup.CENTER, iup.CENTER)
iup.MainLoop()
